/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import com.example.worldresetmod.WorldResetMod;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConfirmResetGui
extends GuiScreen {
    private GuiWorldSelection parentScreen;
    private String message;
    private boolean showSuccess = false;
    private String selectedWorldName;

    public ConfirmResetGui(GuiWorldSelection parentScreen) {
        this.parentScreen = parentScreen;
        this.message = "\u662f\u5426\u91cd\u7f6e\u6240\u6709\u5b58\u6863\u4e16\u754c\u51c0\u5316\u4e4b\u6218\u7684\u8fdb\u5ea6\uff1f\uff08\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff09";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.showSuccess) {
            int buttonWidth = 120;
            this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - buttonWidth / 2, this.field_146295_m / 2 + 60, buttonWidth, 20, "\u786e\u8ba4"));
        } else {
            this.initConfirmationGui();
        }
    }

    private void initConfirmationGui() {
        int buttonY = this.field_146295_m / 2 + 50;
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonSpacing = 20;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = this.field_146294_l / 2 - totalWidth / 2;
        this.field_146292_n.add(new GuiButton(100, startX, buttonY, buttonWidth, buttonHeight, "\u662f"));
        this.field_146292_n.add(new GuiButton(101, startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, "\u5426"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 100) {
            this.performFileDelete();
        } else if (button.field_146127_k == 101) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
        } else if (button.field_146127_k == 200) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
        } else if (button.field_146127_k == 999) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
        } else if (button.field_146127_k == 102) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int messageY = this.field_146295_m / 2 - 40;
        int lineHeight = 15;
        if (this.showSuccess) {
            String message = this.message;
            if (message.startsWith("\u5df2\u6210\u529f\u91cd\u7f6e") && message.contains("\u4e2a\u5b58\u6863\u7684\u4e16\u754c\u51c0\u5316\u4e4b\u6218")) {
                int startX;
                int startIndex = message.indexOf("\u5df2\u6210\u529f\u91cd\u7f6e") + 5;
                int endIndex = message.indexOf("\u4e2a\u5b58\u6863\u7684\u4e16\u754c\u51c0\u5316\u4e4b\u6218");
                String prefix = message.substring(0, startIndex);
                String count = message.substring(startIndex, endIndex);
                String suffix = message.substring(endIndex);
                int prefixWidth = this.field_146289_q.func_78256_a(prefix);
                int countWidth = this.field_146289_q.func_78256_a(count);
                int suffixWidth = this.field_146289_q.func_78256_a(suffix);
                int currentX = startX = centerX - (prefixWidth + countWidth + suffixWidth) / 2;
                this.field_146289_q.func_78276_b(prefix, currentX, messageY, 65280);
                this.field_146289_q.func_78276_b(count, currentX += prefixWidth, messageY, 0xFFFF00);
                this.field_146289_q.func_78276_b(suffix, currentX += countWidth, messageY, 65280);
            } else {
                this.func_73732_a(this.field_146289_q, message, centerX, messageY, 65280);
            }
        } else if (this.message != null && (this.message.contains("\u672a\u627e\u5230") || this.message.contains("\u9519\u8bef") || this.message.contains("\u65e0\u6cd5"))) {
            this.func_73732_a(this.field_146289_q, this.message, centerX, messageY, 0xFF0000);
            this.field_146292_n.clear();
            int buttonWidth = 100;
            this.field_146292_n.add(new GuiButton(102, this.field_146294_l / 2 - buttonWidth / 2, messageY + 40, buttonWidth, 20, "\u8fd4\u56de"));
        } else {
            this.drawMessageWithHighlight(centerX, messageY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawSuccessMessage(int centerX, int y, int lineHeight) {
        int startX;
        String prefix = "\u5df2\u6210\u529f\u91cd\u7f6e";
        String highlight = "\u6240\u6709\u5b58\u6863";
        String suffix = "\u7684\u4e16\u754c\u51c0\u5316\u4e4b\u6218";
        int prefixWidth = this.field_146289_q.func_78256_a(prefix);
        int highlightWidth = this.field_146289_q.func_78256_a(highlight);
        int suffixWidth = this.field_146289_q.func_78256_a(suffix);
        int currentX = startX = centerX - (prefixWidth + highlightWidth + suffixWidth) / 2;
        this.field_146289_q.func_78276_b(prefix, currentX, y, 65280);
        this.field_146289_q.func_78276_b(highlight, currentX += prefixWidth, y, 0xFFFF00);
        this.field_146289_q.func_78276_b(suffix, currentX += highlightWidth, y, 65280);
        this.field_146289_q.func_78276_b("\uff01", currentX + suffixWidth, y, 65280);
    }

    private void drawMessageWithHighlight(int centerX, int y) {
        int startX;
        String message = this.message;
        if (message == null) {
            return;
        }
        String prefix = "\u662f\u5426\u91cd\u7f6e";
        String highlight = "\u6240\u6709\u5b58\u6863";
        String suffix = "\u4e16\u754c\u51c0\u5316\u4e4b\u6218\u7684\u8fdb\u5ea6\uff1f\uff08\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff09";
        int prefixWidth = this.field_146289_q.func_78256_a(prefix);
        int highlightWidth = this.field_146289_q.func_78256_a(highlight);
        int suffixWidth = this.field_146289_q.func_78256_a(suffix);
        int currentX = startX = centerX - (prefixWidth + highlightWidth + suffixWidth) / 2;
        this.field_146289_q.func_78276_b(prefix, currentX, y, 0xFFFFFF);
        this.field_146289_q.func_78276_b(highlight, currentX += prefixWidth, y, 0xFFFF00);
        this.field_146289_q.func_78276_b(suffix, currentX += highlightWidth, y, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "\u8bf7\u9009\u62e9:", centerX, y - 25, 0xCCCCCC);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            if (this.showSuccess) {
                this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
            }
        }
    }

    private void performFileDelete() {
        this.message = "\u6b63\u5728\u5220\u9664\u6240\u6709\u5b58\u6863\u7684\u6587\u4ef6...";
        this.showSuccess = false;
        this.func_73866_w_();
        try {
            int deletedCount = this.deleteAllOverlastDatFiles();
            if (deletedCount > 0) {
                this.showSuccess = true;
                this.message = "\u5df2\u6210\u529f\u91cd\u7f6e" + deletedCount + "\u4e2a\u5b58\u6863\u7684\u4e16\u754c\u51c0\u5316\u4e4b\u6218\uff01";
                this.func_73866_w_();
            } else {
                this.showErrorMessage("\u672a\u627e\u5230\u4efb\u4f55\u9700\u8981\u91cd\u7f6e\u7684\u5b58\u6863\u6587\u4ef6\u3002");
            }
        }
        catch (Exception e) {
            this.showErrorMessage("\u5220\u9664\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    private int deleteAllOverlastDatFiles() {
        File savesDir = new File(this.field_146297_k.field_71412_D, "saves");
        if (!savesDir.exists() || !savesDir.isDirectory()) {
            return 0;
        }
        File[] worldFolders = savesDir.listFiles(File::isDirectory);
        if (worldFolders == null || worldFolders.length == 0) {
            return 0;
        }
        int deletedCount = 0;
        for (File worldFolder : worldFolders) {
            try {
                File overlastFile = new File(worldFolder, "data/overlast.dat");
                if (!overlastFile.exists() || !overlastFile.delete()) continue;
                ++deletedCount;
                WorldResetMod.logger.info("Deleted overlast.dat from world: " + worldFolder.getName());
            }
            catch (Exception e) {
                WorldResetMod.logger.warn("Failed to delete overlast.dat from world: " + worldFolder.getName() + " - " + e.getMessage());
            }
        }
        return deletedCount;
    }

    private void showErrorMessage(String errorText) {
        this.message = errorText;
        this.showSuccess = false;
        this.func_73866_w_();
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                if (this.field_146297_k.field_71462_r == this) {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "ErrorMessageTimer").start();
    }

    private String getSelectedWorldName() {
        if (this.parentScreen == null) {
            return null;
        }
        try {
            File savesDir = new File(this.field_146297_k.field_71412_D, "saves");
            if (!savesDir.exists()) {
                WorldResetMod.logger.warn("Saves directory not found");
                return null;
            }
            File[] worldFolders = savesDir.listFiles(File::isDirectory);
            if (worldFolders == null || worldFolders.length == 0) {
                WorldResetMod.logger.warn("No world folders found");
                return null;
            }
            Arrays.sort(worldFolders, (f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
            try {
                Field buttonListField = GuiScreen.class.getDeclaredField("buttonList");
                buttonListField.setAccessible(true);
                List buttonList = (List)buttonListField.get(this.parentScreen);
                for (Object buttonObj : buttonList) {
                    GuiButton button;
                    if (!(buttonObj instanceof GuiButton) || !this.isWorldButton(button = (GuiButton)buttonObj) || !button.field_146124_l || button.field_146126_j == null) continue;
                    String buttonText = button.field_146126_j.trim();
                    for (File worldFolder : worldFolders) {
                        if (!worldFolder.getName().equals(buttonText)) continue;
                        WorldResetMod.logger.info("Detected selected world: " + worldFolder.getName());
                        return worldFolder.getName();
                    }
                }
            }
            catch (Exception reflectionError) {
                WorldResetMod.logger.warn("Could not access button list via reflection: " + reflectionError.getMessage());
            }
            File mostRecentWorld = Arrays.stream(worldFolders).max((f1, f2) -> Long.compare(f1.lastModified(), f2.lastModified())).orElse(null);
            if (mostRecentWorld != null) {
                WorldResetMod.logger.info("Using most recent world as fallback: " + mostRecentWorld.getName());
                return mostRecentWorld.getName();
            }
            WorldResetMod.logger.warn("Using first world folder as final fallback");
            return worldFolders[0].getName();
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Error getting world selection", (Throwable)e);
            return null;
        }
    }

    private boolean isWorldButton(GuiButton button) {
        return button.field_146127_k >= 1 && button.field_146127_k <= 100 && !button.field_146126_j.equals("Create New World") && !button.field_146126_j.equals("Delete World") && !button.field_146126_j.equals("Rename World") && !button.field_146126_j.equals("Re-Create World");
    }
}

